﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI;
using System.Collections.Generic;
using System.Windows;
using System.Linq;
using System.Collections;
using gov.va.med.vbecs.Common;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class PatientABSViewModel : SpecimenTabViewModel
    {
        public Visibility SC1Visibility { get; private set; }
        public Visibility SC2Visibility { get; private set; }
        public Visibility SC3Visibility { get; private set; }
        public Visibility SC4Visibility { get; private set; }
        public Visibility SC5Visibility { get; private set; }

        public PatientABSViewModel(Patient patient, string specimentUid, VbecsBaseForm vbecsBaseForm, IEnumerable<SpecimenItemViewModel> pendingSpecimenTestList)
            : base(patient, specimentUid, vbecsBaseForm, pendingSpecimenTestList, StrRes.HelpFiles.UC115.AutomatedTestingPatientAbsTab())
        {
            // Toggle the column visibility based on if we have any data for the respective column
            var absList = pendingSpecimenTestList.Select(x => x.PendingSpecimenTestModel as PendingSpecimenAbsModel).Where(w => w != null);

            SC1Visibility = absList.Any(x => x.SC1 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC2Visibility = absList.Any(x => x.SC2 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC3Visibility = absList.Any(x => x.SC3 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC4Visibility = absList.Any(x => x.SC4 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC5Visibility = absList.Any(x => x.SC5 != null) ? Visibility.Visible : Visibility.Collapsed;
        }   
    }
}
